Imports System.Security.Permissions
Imports System.Security.Principal
Imports System.Security
Imports System.Threading


Public Class Sort

#Region " Metody publiczne - Public "
  Public Sub New(ByVal Args() As String)
    Data = Args
  End Sub

  Public Sub BubbleSort()
    Dim I, J As Integer

    For I = Data.GetLowerBound(0) To Data.GetUpperBound(0) - 1
      For J = I + 1 To Data.GetUpperBound(0)
        If (Data(I) > Data(J)) Then
          Dim Temp As Object
          Temp = Data(I)
          Data(I) = Data(J)
          Data(J) = Temp
        End If
      Next
    Next
  End Sub

  Public Shared Sub Run()
    Sort.DoCommand(GetInput().Split(", ".ToCharArray()))
  End Sub

  Public Shared Sub DoCommand(ByVal Args() As String)
    Dim Sorter As New Sort(Args)
    Dim NewThread As New Thread(AddressOf Sorter.Process)
    NewThread.Start()
  End Sub

#End Region

#Region " Metody prywatne - Private "
  Private Data() As String

  Private Sub Process()
    BubbleSort()
    Display()
  End Sub

  Private Sub Display()
    Dim Enumerator As IEnumerator = Data.GetEnumerator
    While Enumerator.MoveNext
      System.Console.WriteLine(Enumerator.Current)
    End While
  End Sub

  Private Shared Sub Prompt()
    Const Text As String = _
      "Wprowad elementy do sortowania, rozdzielajc je przecinkami: "
    System.Console.Write(Text)
  End Sub

  Private Shared Sub Validate(ByVal Input As String)

    Const Text As String = "Skadnia polecenia: console 1,2,3,4,...,n"

    If (Input = vbNullString) Then
      System.Console.Error.WriteLine(Text)
      Thread.Sleep(2500)
      End
    End If

  End Sub

  Private Shared Function GetInput() As String
    If (Command() = vbNullString) Then
      Prompt()
      GetInput = System.Console.ReadLine()
    Else
      GetInput = Command()
    End If

    Validate(GetInput)
    Return GetInput
  End Function

#End Region

End Class


Module Module1

  Private NewError As System.IO.StreamWriter

  Sub SetErrorDevice()
    NewError = New System.IO.StreamWriter("error.log")
    NewError.AutoFlush = True
    System.Console.SetError(NewError)
  End Sub

  Sub Main()
    SetErrorDevice()
    Sort.Run()
    Thread.Sleep(2500)
  End Sub

End Module
